<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../gUtil/GestoreTabella.php";
    include "../classi/Tabella.php";
    include "include/controlloLogin.php";
    
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_STRING) : "";
    $segnalato         = isset($_GET["segnalato"]) ? filter_input(INPUT_GET,"segnalato",FILTER_SANITIZE_STRING) : "";
    $tipo              = "categoriaArticolo";
    
    $parametriRicerca = $cerca!="" ? array("testo"=>$cerca,"segnalato"=>$segnalato) : array("segnalato"=>$segnalato);
    if(isset($_GET["efficacia"])) {
        $parametriRicerca["efficacia"] = filter_input(INPUT_GET, "efficacia",FILTER_SANITIZE_STRING);
    }

    if(isset($_GET["stato"])) {
        $parametriRicerca["stato"] = filter_input(INPUT_GET, "stato",FILTER_SANITIZE_STRING);
    }
    
    $parametri = array("tabella"=>"geecB_commenti", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
        
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"gestioneCommenti.php");
    
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <title>Amministrazione di Geecom CMS - gestione commenti</title>

    <?php
        include "include/cssBaseAreaAmministrativa.php";
    ?>
</head>

<body>
   
    <header>
        <?php  
            include "include/barraSuperiore.php";

            include "include/header.php";

            include "include/barraMenu.php";
        ?>
    </header>
    <?php 
    
        if(isset($_GET["status"])) {
            if($_GET["status"]==1) {
                    echo"<p class=\"alert alert-success\">Utente creato</p>";
            }
            else if($_GET["status"]==2) {
                    echo"<p class=\"alert alert-success\">Utente modificato</p>";
            }
            else if($_GET["status"]==4) {
                    echo"<p class=\"alert alert-success\">Stato dell'amministratore modificato</p>";
            }
            else if($_GET["status"]==400) {
                    echo"<p class=\"alert alert-danger\">Indirizzo email già esistente</p>";
            }
            else { //status = 5
                    echo"<p class=\"alert alert-success\">Utente eliminato</p>";
            }
        }
    ?>
     <!-- Modal box conferma cancellazione elemento-->
    <div class="modal fade" id="modalEliminaComunicazione" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Eliminare il commento?</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="d-flex flex-row justify-content-center">
                    <input type="text" class="d-none" id="comunicazioneDaEliminare" >
                    <div class="align-self-center text-center">
                        <span class="align-self-center text-primary"><em id="nomeComunicazioneDaEliminare"></em></span>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-default" data-dismiss="modal">Annulla</button>
              <button type="button" class="btn btn-primary" onclick="{eseguiEliminazioneComunicazione()}" >Elimina</button>
            </div>
        </div><!-- /.modal-content -->
      </div><!-- /.modal-dialog -->
    </div><!-- /.Modal box-->
    
    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div id="contenutoPrincipale" class="row">
                <div class="col py-4">
                    <div class="card mb-4 box-shadow-lite">
                        <div class="card-header">
                            <span class="card-title mr-2">Elenco commenti</span>
                        </div>
                        <div class="panel panel-default">
                            <div class="card-body collapse show">
                                <div class="d-flex justify-content-between mb-3">
                                    <?php
                                        $ricerca->stampaSelectNumeroElementi($cerca);
                                    ?>
                                    <form class="form-inline" name="formRicerca" action="gestioneCommenti.php">
                                        <div class="input-group">
                                            <input type="text" class="d-none" name="elementiPerPagina" value="<?php echo $elementiPerPagina ?>">
                                            <input type="text" class="form-control" id="cerca" aria-describedby="cerca" name="cerca" placeholder="Cerca..." value="<?php echo $cerca ?>">
                                            <select name="segnalato" class="custom-select">
                                                <option value="" <?php echo(($segnalato=="") ? "selected" : ""); ?>>Tutti i commenti</option>
                                                <option value="si" <?php echo(($segnalato=="si") ? "selected" : ""); ?>>Commenti segnalati</option>
                                            </select>
                                            <div class="input-group-append">
                                                <button type="submit" class="btn btn-primary"><i class="fas fa-search"></i></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="table-responsive table-sm">
                                    <?php
                                    
                                        if(isset($_GET["pag"])) {
                                            $ris = $ricerca->eseguiRicerca($_GET["pag"]);
                                        }
                                        else {
                                            $ris = $ricerca->eseguiRicerca(1);
                                        }
                                        
                                        $colonne = array("ID","Autore","Email","Testo","Data inserimento","In risposta a","");
                                        $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                        
                                        $tabella->setTipo("normale");
                                        while($commento = $ris->fetch_assoc()) {
                                            $dataCreazione = date("d/m/Y",strtotime($commento["dataCreazione"]));
                                            $testoEscape   = filter_var($commento["testo"],FILTER_SANITIZE_ADD_SLASHES);
                                            $azioni    = array("elimina"=>"eliminaComunicazione({$commento["id"]},'$testoEscape')");
                                            $contenuto = $geecomDb->leggiSingolaRiga("geecB_contenuti",$commento["idContenuto"]);
                                            $codiceCommentoSegnalato = ($commento["segnalato"]=="si") ? "<i class=\"fas fa-exclamation-triangle mr-2 text-warning\"></i>" : "";
                                            $tabella->aggiungiNuovaRiga(array($commento["id"],$commento["nomeAutore"],$commento["email"],$codiceCommentoSegnalato.$commento["testo"],date("d/m/Y",strtotime($commento["dataCreazione"])),"<b><a href=\"creaContenuto.php?id={$contenuto["id"]}\">{$contenuto["titolo"]}</a></b>"),$azioni);                                            
                                        }

                                        $tabella->stampa("rigaCommento", 0);
                                        $ricerca->stampaPaginazione(true,"gestioneComunicazioni.php");
                                    ?>
                                </div>
                            </div>
                            <!-- /tabella -->
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
    
    <?php 
        include "include/footer.php";
        
        include "include/modal/modalMenuComponenti.php";
                
        include "include/modal/cambiaPassword.php";
                
        include "include/modal/operazioneCompletata.php";
        
        include "include/jsBaseAreaAmministrativa.php";
    ?>
	
    <script type="text/javascript">

        function eliminaComunicazione(idComunicazione,nome) {
            document.getElementById("comunicazioneDaEliminare").value = idComunicazione;
            document.getElementById("nomeComunicazioneDaEliminare").innerHTML = nome;
            $('#modalEliminaComunicazione').modal('show');
        }
        
        function eseguiEliminazioneComunicazione() {
            var id = $('#comunicazioneDaEliminare').val();
            $.ajax({
                type:"POST",
                url:"../controller/controllerCommenti.php",
                data:{
                    operazione:"elimina",
                    id:id
                },
                success:function(result) {
                    if(result=="ok") {
                        document.getElementById("rigaCommento"+id).className = "d-none";
                        $('#modalEliminaComunicazione').modal('hide');
                    }
                    else {
                        alert(result);
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
    </script>
</body>
</html>